﻿//////////////////////////////////////////////
// JpgMonochromeEncoder.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkImages
{
	struct AlignmentDescriptor ;
}

/// Includes ---------------------------------

// nkImages
#include "../Data/JpgFrame.h"
#include "../Data/JpgHuffmanTable.h"
#include "../Data/JpgQuantizationTable.h"
#include "../Data/JpgScan.h"

#include "JpgDecodeResult.h"

// nkMemory
#include <NilkinsMemory/Containers/Buffer.h>

// Standards
#include <vector>

/// Class ------------------------------------

namespace nkImages::jpg
{
	class JpgMonochromeEncoder final
	{
		public :

			// Decoding
			static JpgDecodeResult decodeBaseline (const JpgFrame& frameInfo, const std::vector<JpgScan>& scanData, const std::vector<JpgQuantizationTable>& quantizationTables, const AlignmentDescriptor& alignmentDescriptor) ;
			static JpgDecodeResult decodeProgressive (const JpgFrame& frameInfo, const std::vector<JpgScan>& scanData, const std::vector<JpgQuantizationTable>& quantizationTables, const AlignmentDescriptor& alignmentDescriptor) ;
			static JpgDecodeResult decode (const JpgFrame& frameInfo, const std::vector<JpgScan>& scanData, const std::vector<JpgQuantizationTable>& quantizationTables, const AlignmentDescriptor& alignmentDescriptor) ;
	} ;
}